package gov.va.genisis2.converter;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.common.enums.WorkflowStatusEnum;
import gov.va.genisis2.dto.RequestDTO;
import gov.va.genisis2.model.DataType;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.util.DateUtil;

/**
 * This class is used to convert RequestDTO to Request entity and vice-versa.
 * 
 * @author PII
 *
 */
@Component
public class RequestConverter implements Converter<Request, RequestDTO> {

	@Autowired
	private RequestTypeConverter requestTypeConverter;

	@Autowired
	private StudyApprovalConverter studyApprovalConverter;

	@Autowired
	private SourceConverter sourceConverter;
	
	@Autowired
	private DataTypeConverter dataTypeConverter;
	

	@Override
	public RequestDTO convert(Request request) {
		RequestDTO requestDto = new RequestDTO();

		requestDto.setId(request.getId());
		requestDto.setProcessId(request.getProcessId());
		requestDto.setTitle(request.getTitle());
		requestDto.setDescription(request.getDescription());
		requestDto.setStatusDescription(request.getStatusDescription());
		requestDto.setCreatedOn(request.getCreatedOn());
		requestDto.setModifiedOn(request.getModifiedOn());
		requestDto.setCreatedBy(request.getCreatedBy());
		requestDto.setModifiedBy(request.getModifiedBy());
		requestDto.setApproverId(request.getApproverId());
		requestDto.setTaskId(request.getTaskId());

		requestDto.setRequestTypeId(request.getRequestTypeId());
		if (null != request.getRequestType()) {
			requestDto.setRequestType(requestTypeConverter.convert(request.getRequestType()));
		}
		if (request.getDataTypeId() !=null)
		requestDto.setDataTypeId(request.getDataTypeId());
		
		if (null != request.getDataType()) {
			requestDto.setDataType(dataTypeConverter.convert(request.getDataType()));
		}
		
		requestDto.setStudyApprovalId(request.getStudyApprovalId());
		if (null != request.getStudyApproval()) {
			requestDto.setStudyApproval(studyApprovalConverter.convert(request.getStudyApproval()));
		}

		if(request.getSourceId() != null)
		requestDto.setSourceId(request.getSourceId());
		if (null != request.getSource()) {
			requestDto.setSource(sourceConverter.convert(request.getSource()));
		}

		return requestDto;
	}

	public Request convert(RequestDTO requestDto) {
		Request request = new Request();

		request.setId(requestDto.getId());
		request.setProcessId(0);
		request.setTitle(requestDto.getTitle());
		request.setDescription(requestDto.getDescription());
		request.setStatusDescription("Draft");
		request.setCreatedOn(DateUtil.getTodaysDate());
		request.setModifiedOn(requestDto.getModifiedOn());
		request.setCreatedBy(requestDto.getCreatedBy());
		request.setModifiedBy(requestDto.getModifiedBy());
		request.setApproverId(requestDto.getApproverId());
		request.setTaskId(requestDto.getTaskId());
		request.setDataTypeId(0);
		request.setSourceId(0);
		
		if (requestDto.getDataTypeId() > 0) {
			request.setDataTypeId(requestDto.getDataTypeId());
			DataType dataType = new DataType();
			dataType.setId(requestDto.getDataTypeId());
			request.setDataType(dataType);
		}

		if (requestDto.getRequestTypeId() > 0) {
			request.setRequestTypeId(requestDto.getRequestTypeId());

			RequestType requestType = new RequestType();
			requestType.setId(requestDto.getRequestTypeId());
			request.setRequestType(requestType);
		}

		if (requestDto.getSourceId() > 0) {
			request.setSourceId(requestDto.getSourceId());

			Source source = new Source();
			source.setId(requestDto.getSourceId());
			request.setSource(source);
		}

		if (requestDto.getStudyApprovalId() > 0) {
			request.setStudyApprovalId(requestDto.getStudyApprovalId());

			StudyApproval studyApproval = new StudyApproval();
			studyApproval.setId(requestDto.getStudyApprovalId());
			request.setStudyApproval(studyApproval);
		}

		return request;
	}

	public List<RequestDTO> convertRequests(List<Request> requests) {
		List<RequestDTO> requestDtos = null;

		if (!requests.isEmpty()) {
			requestDtos = new ArrayList<>();
			for (Request request : requests) {
				requestDtos.add(convert(request));
			}
		}

		return requestDtos;
	}

	public Request populateRequest(int id, RequestDTO changeRequestIn, String operation, Request databaseRequest,
			Request changeRequest) {

		if (StringUtils.equalsIgnoreCase(operation, WorkflowStatusEnum.RETURNTODDM.getDesc())) {
			changeRequest.setStatusDescription(WorkflowStatusEnum.SUBMITTED.getDesc());
		} else if (!StringUtils.equalsIgnoreCase(operation, "Update")) {
			changeRequest.setStatusDescription(operation);
		}

		if (changeRequest.getProcessId() == 0)
			changeRequest.setProcessId(databaseRequest.getProcessId());

		if (changeRequest.getSource() == null)
			changeRequest.setSource(databaseRequest.getSource());

		if (changeRequest.getStudyApproval() == null)
			changeRequest.setStudyApproval(databaseRequest.getStudyApproval());

		if (changeRequest.getRequestType() == null)
			changeRequest.setRequestType(databaseRequest.getRequestType());
		
		if (changeRequest.getDataType() == null)
			changeRequest.setDataType(databaseRequest.getDataType());
		

		if (StringUtils.isBlank(changeRequest.getStatusDescription()))
			changeRequest.setStatusDescription(databaseRequest.getStatusDescription());

		if (StringUtils.isBlank(changeRequest.getTitle()))
			changeRequest.setTitle(databaseRequest.getTitle());

		if (StringUtils.isBlank(changeRequest.getDescription()))
			changeRequest.setDescription(databaseRequest.getDescription());

		changeRequest.setModifiedOn(DateUtil.getTodaysDate());
		changeRequest.setModifiedBy(changeRequestIn.getCreatedBy());

		changeRequest.setCreatedBy(databaseRequest.getCreatedBy());
		changeRequest.setCreatedOn(databaseRequest.getCreatedOn());
		changeRequest.setApproverId(databaseRequest.getApproverId());

		changeRequest.setId(id);

		return changeRequest;
	}

	
}
